/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.net.MalformedURLException;
import org.tigris.subversion.svnclientadapter.StringUtils;

public class SVNUrl {
    protected static final char SEGMENT_SEPARATOR = '/';
    private String protocol;
    private String[] segments;
    private String host;
    private int port;

    public SVNUrl(String string) throws MalformedURLException {
        if (string == null) {
            throw new MalformedURLException("Svn url cannot be null. Is this a versioned resource?");
        }
        this.parseUrl(string.trim());
    }

    private SVNUrl(String string, String string2, int n, String[] stringArray) {
        this.protocol = string;
        this.host = string2;
        this.port = n;
        this.segments = stringArray;
    }

    public SVNUrl appendPath(String string) {
        String[] stringArray;
        String[] stringArray2 = StringUtils.split(string, '/');
        if (stringArray2.length > 0 && stringArray2[0].equals("")) {
            stringArray = new String[stringArray2.length - 1];
            System.arraycopy(stringArray2, 1, stringArray, 0, stringArray2.length - 1);
            stringArray2 = stringArray;
        }
        stringArray = new String[this.segments.length + stringArray2.length];
        System.arraycopy(this.segments, 0, stringArray, 0, this.segments.length);
        System.arraycopy(stringArray2, 0, stringArray, this.segments.length, stringArray2.length);
        return new SVNUrl(this.protocol, this.host, this.port, stringArray);
    }

    private void parseUrl(String string) throws MalformedURLException {
        String string2 = string;
        int n = string2.indexOf("://");
        if (n == -1) {
            throw new MalformedURLException("Invalid svn url :" + string);
        }
        this.protocol = string2.substring(0, n).toLowerCase();
        if (!(this.protocol.equalsIgnoreCase("http") || this.protocol.equalsIgnoreCase("https") || this.protocol.equalsIgnoreCase("file") || this.protocol.equalsIgnoreCase("svn") || this.protocol.startsWith("svn+"))) {
            throw new MalformedURLException("Invalid svn url :" + string);
        }
        if ((string2 = string2.substring(n + 3)).length() == 0) {
            throw new MalformedURLException("Invalid svn url :" + string);
        }
        n = string2.indexOf("/");
        if (n == -1) {
            n = string2.length();
        }
        if (!this.protocol.equalsIgnoreCase("file")) {
            String string3 = string2.substring(0, n).toLowerCase();
            String[] stringArray = StringUtils.split(string3, ':');
            if (stringArray.length == 2) {
                this.host = stringArray[0];
                try {
                    this.port = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException("Invalid svn url :" + string);
                }
            } else {
                this.host = stringArray[0];
                this.port = SVNUrl.getDefaultPort(this.protocol);
            }
        } else {
            this.port = -1;
            this.host = n == 0 ? "" : string2.substring(0, n);
        }
        string2 = n < string2.length() ? string2.substring(n + 1) : "";
        this.segments = StringUtils.split(string2, '/');
    }

    public static int getDefaultPort(String string) {
        int n = -1;
        if ("svn".equals(string)) {
            n = 3690;
        } else if ("http".equals(string)) {
            n = 80;
        } else if ("https".equals(string)) {
            n = 443;
        } else if (string != null && string.startsWith("svn+")) {
            n = 22;
        }
        return n;
    }

    private String get() {
        StringBuffer stringBuffer = new StringBuffer(this.calculateUrlLength());
        stringBuffer.append(this.getProtocol());
        stringBuffer.append("://");
        stringBuffer.append(this.getHost());
        if (this.getPort() != SVNUrl.getDefaultPort(this.getProtocol())) {
            stringBuffer.append(":");
            stringBuffer.append(this.getPort());
        }
        for (int i = 0; i < this.segments.length; ++i) {
            stringBuffer.append('/');
            stringBuffer.append(this.segments[i]);
        }
        return stringBuffer.toString();
    }

    private int calculateUrlLength() {
        int n = 3;
        if (this.getProtocol() != null) {
            n += this.getProtocol().length();
        }
        if (this.getHost() != null) {
            n += this.getHost().length();
        }
        if (this.getPort() != SVNUrl.getDefaultPort(this.getProtocol())) {
            ++n;
            n += String.valueOf(this.getPort()).length();
        }
        for (int i = 0; i < this.segments.length; ++i) {
            ++n;
            n += this.segments[i].length();
        }
        return n;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.get();
    }

    public String[] getPathSegments() {
        return this.segments;
    }

    public String getLastPathSegment() {
        if (this.segments.length == 0) {
            return "";
        }
        return this.segments[this.segments.length - 1];
    }

    public SVNUrl getParent() {
        if (this.segments.length == 0 || this.segments.length == 1 && (this.host == null || this.host.length() == 0)) {
            return null;
        }
        String[] stringArray = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, stringArray, 0, this.segments.length - 1);
        return new SVNUrl(this.protocol, this.host, this.port, stringArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SVNUrl)) {
            return false;
        }
        SVNUrl sVNUrl = (SVNUrl)object;
        return this.get().equals(sVNUrl.get());
    }

    public int hashCode() {
        return this.get().hashCode();
    }
}

